#ifndef JSON_H
#define JSON_H
#include <string>
#include <vector>
#include <map>
#include <iostream>
using namespace std;
class JSON {
public:
   //    
   enum JSON_type { 
      null_type=0,
      bool_type,
      number_type,
      string_type,
      array_type,
      object_type
   };
   //  
   typedef vector<JSON> array;
   //   
   typedef map<string, JSON> object;

   // 
   JSON();
   JSON(const JSON &);

   // -
   JSON(nullptr_t);
   JSON(bool);
   JSON(double);
   JSON(int);
   JSON(const string &);
   JSON(const char []);
   JSON(const array &);
   JSON(const object &);

   //  
   JSON &operator=(const JSON &);
   //   
   JSON_type type() const;

   //   e  
   void push(const JSON& e);
   //     
   void pop();
   //  i-  
   JSON &operator[](int i);
   const JSON &operator[](int i) const;
   //   
   int length() const;

   //       key
   JSON &operator[](const string & key);
   const JSON &operator[](const string & key) const;
   JSON &operator[](const char key[]);
   const JSON &operator[](const char key[]) const;
   //      key
   bool has(const string & key) const;
   //     key
   void erase(const string &key);

   //  
   operator bool() const;
   operator double() const;
   operator const char *() const;
   operator string() const;

   //    
   friend ostream &operator<<(ostream &o, const JSON & j);
   //    
   friend istream &operator>>(istream &i, JSON & j);
private:
   JSON_type value_type; //  
   bool bool_value;      //     
   double number_value;  //    
   string string_value;  //    
   array array_value;    //    
   object object_value;  //     
   void clear();     //   , =null
};
#endif
