#ifndef INTERFACE_H
#define INTERFACE_H

#include "graphics.h"
#include <string>
using namespace std;

//     
class DrawObject {
protected:
   int x1,y1,x2,y2; //   ,    
public:
   //       x1,y1
   //      x2,y2
   DrawObject(int x1, int y1, int x2, int y2):x1(x1),y1(y1),x2(x2),y2(y2) {}
   virtual ~DrawObject(){} // 
   bool in(int x, int y); //  x, y  
   int get_top() { return y1+1; } //  
   int get_left() { return x1+1; } //  
   int get_height() { return y2-y1-1; } // 
   int get_width() { return x2-x1-1; } // 
   virtual void draw()=0; //  
};
//      
class SelectedColors: public DrawObject {
   int fc, //  
       bc; //  
   //     x1,y1,x2,y2
   SelectedColors(int x1, int y1, int x2, int y2):
      DrawObject(x1,y1,x2,y2),fc(BLACK),bc(WHITE) {}
public:
   static SelectedColors &instance(); //    
   void draw(); //  
   void set_fc(int c); //   
   int get_fc() { return fc; } //    
   void set_bc(int c); //   
   int get_bc() { return bc; } //   
};
//         
class StatusLine: public DrawObject {
   int x,y; //  
   bool edit;
   string name; //  
   //     x1,y1,x2,y2
   StatusLine(int x1, int y1, int x2, int y2):
      DrawObject(x1,y1,x2,y2),x(0),y(0),name("untitled.bmp") {}
public:
   static StatusLine &instance(); //  
   void draw(); //  
   void set_xy(int x, int y); //   
   void set_name(const string& name); //   
   string get_name() { return name; } //   
   void edit_name(); //   
};
//   ,   
class ControlObject: public DrawObject {
public:
   //     x1,y1,x2,y2
   ControlObject(int x1, int y1, int x2, int y2):DrawObject(x1,y1,x2,y2) {}
   virtual void press()=0; //    
};
//   -   
typedef void (*fun_ptr)();
//    
class PaintArea: public ControlObject {
   fun_ptr tool; //  
   //     x1,y1,x2,y2
   PaintArea(int x1, int y1, int x2, int y2):
      ControlObject(x1,y1,x2,y2),tool(nullptr) {}
public:
   static PaintArea &instance(); //   
   void draw(); //  
   void press(); //    
   void set_tool(fun_ptr t) { tool=t; } //   
   fun_ptr get_tool() { return tool; } //    
   void save(const string& name); //  
   void load(const string& name); //  
};

#endif
