#include "interface.hpp"

bool DrawObject::in(int x, int y) {
   return x>x1 && y>y1 && x<x2 && y<y2;
}
SelectedColors &SelectedColors::instance() {
   static SelectedColors sc(20,120,70,170);
   return sc;
}
void SelectedColors::draw() {
   setfillstyle(SOLID_FILL,fc);
   bar(x1,y1,x2,y2);
   setfillstyle(SOLID_FILL,bc);
   int dx=(x2-x1)/4;
   int dy=(y2-y1)/4;
   bar(x1+dx,y1+dx,x2-dx,y2-dy);
   setcolor(BLACK);
   rectangle(x1,y1,x2,y2);
}
void SelectedColors::set_fc(int c) {
   fc=c;
   draw();
}
void SelectedColors::set_bc(int c) {
   bc=c;
   draw();
}
StatusLine &StatusLine::instance() {
   static StatusLine sl(100,550,780,580);
   return sl;
}
void StatusLine::draw() {
   setfillstyle(SOLID_FILL,WHITE);
   bar(x1,y1,x2,y2);
   setcolor(BLACK);
   rectangle(x1,y1,x2,y2);
   string s="X: "+to_string(x)+" Y: "+to_string(x)+(edit?"   : ":" : ")+name;
   setbkcolor(WHITE);
   outtextxy(x1+10,y1+5,s.c_str());
}
void StatusLine::set_xy(int x, int y) {
   if(x==this->x && y==this->y) return;
   this->x=x;
   this->y=y;
   draw();
}
void StatusLine::set_name(const string& n) {
   name=n;
   draw();
}
void StatusLine::edit_name() {
   int ch;
   edit=1;
   while(1) {
     draw();
     ch=getch();
     if(ch==KEY_ENTER || ch==KEY_ESC) break;
     else if(ch==KEY_BACKSPACE && name.size()>0) name.pop_back();
     else if(ch>' ' && ch<='z') name+=(char)ch;
   }
   edit=0;
   draw();
}
PaintArea &PaintArea::instance() {
   static PaintArea pa(100,20,780,550);
   return pa;
}
void PaintArea::draw() {
   setfillstyle(SOLID_FILL,WHITE);
   bar(x1,y1,x2,y2);
   setcolor(BLACK);
   rectangle(x1,y1,x2,y2);
}
void PaintArea::press() {
  tool();
}
void PaintArea::save(const string& name) {
  IMAGE *pic=createimage(x2-x1-1,y2-y1-1);
  getimage(x1+1,y1+1,x2-1,y2-1,pic);
  saveBMP(StatusLine::instance().get_name().c_str(),pic);
  freeimage(pic);
}
void PaintArea::load(const string& name) {
  IMAGE *pic=loadBMP(StatusLine::instance().get_name().c_str());
   if(pic)
   {
     setviewport(x1,y1,x2,y2,1);
     putimage(1,1,pic,COPY_PUT);
     setviewport(0,0,getmaxx(),getmaxy(),1);
     freeimage(pic);
   }
}
