#include "button.hpp"

void ColorButton::draw() {
   setfillstyle(SOLID_FILL,c);
   bar(x1,y1,x2,y2);
   setcolor(BLACK);
   rectangle(x1,y1,x2,y2);
}
void ColorButton::press() {
   if(mousebuttons()==1)
      SelectedColors::instance().set_fc(c);
   else
      SelectedColors::instance().set_bc(c);
}
void IconButton::draw() {
   setfillstyle(SOLID_FILL,WHITE);
   bar(x1,y1,x2,y2);
   putimage(x1+1,y1+1,image,COPY_PUT);
   setcolor(BLACK);
   rectangle(x1,y1,x2,y2);
}
void CommandButton::press() {
   action();
}
void ToolButton::press() {
   PaintArea::instance().set_tool(tool);
}
void pencil_tool() {
   int x=mousex();
   int y=mousey();
   moveto(x,y);
   while(1) {
      int b=mousebuttons();
      if(!b) break;
      x=mousex();
      y=mousey();
      if(!PaintArea::instance().in(x,y)) break;
      if(b==1)
         setcolor(SelectedColors::instance().get_fc());
      else
         setcolor(SelectedColors::instance().get_bc());
      lineto(x,y);
      StatusLine::instance().set_xy(x-PaintArea::instance().get_left(),y-PaintArea::instance().get_top());
   }
}
void rect_shape(int x1, int y1, int x2, int y2) {
   setwritemode(XOR_PUT);
   setcolor(WHITE);
   rectangle(x1,y1,x2,y2);
   setwritemode(COPY_PUT);
}
void line_shape(int x1, int y1, int x2, int y2) {
   setwritemode(XOR_PUT);
   setcolor(WHITE);
   line(x1,y1,x2,y2);
   setwritemode(COPY_PUT);
}
bool elastic_tool(int &x1, int &y1, int &x2, int &y2, void (*shape)(int x1, int y1, int x2, int y2)) {
   x1=mousex();
   y1=mousey();
   x2=x1;
   y2=y1;
   shape(x1,y1,x2,y2);
   while(1) {
      int b=mousebuttons();
      if(!b) break;
      int xn=mousex();
      int yn=mousey();
      if(!PaintArea::instance().in(xn,yn)) {
         shape(x1,y1,x2,y2);
         return 0; 
      }
      if(xn!=x2 || yn!=y2)
      {
         shape(x1,y1,x2,y2);
         x2=xn;
         y2=yn;
         shape(x1,y1,x2,y2);
         StatusLine::instance().set_xy(x2-PaintArea::instance().get_left(),y2-PaintArea::instance().get_top());
      }
   }
   shape(x1,y1,x2,y2);
   return 1;
}

void line_tool() {
   int x1,y1,x2,y2;
   if(elastic_tool(x1,y1,x2,y2,line_shape)) {
      setcolor(SelectedColors::instance().get_fc());
      line(x1,y1,x2,y2);
   }
}
void rect_tool() {
   int x1,y1,x2,y2;
   if(elastic_tool(x1,y1,x2,y2,rect_shape)) {
      setcolor(SelectedColors::instance().get_fc());
      rectangle(x1,y1,x2,y2);
   }
}
void fillrect_tool() {
   int x1,y1,x2,y2;
   if(elastic_tool(x1,y1,x2,y2,rect_shape)) {
      setfillstyle(SOLID_FILL,SelectedColors::instance().get_bc());
      bar(x1,y1,x2,y2);
      setcolor(SelectedColors::instance().get_fc());
      rectangle(x1,y1,x2,y2);
   }
}
void load_command() {
   StatusLine::instance().edit_name();
   PaintArea::instance().load(StatusLine::instance().get_name());
}
void save_command() {
   StatusLine::instance().edit_name();
   PaintArea::instance().save(StatusLine::instance().get_name());
}
